/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.attribute.loader.basic;

import com.almworks.jira.structure.api.attribute.AttributeSpec;
import com.almworks.jira.structure.api.attribute.AttributeValue;
import com.almworks.jira.structure.api.attribute.loader.PropagateAttributeContext;
import com.almworks.jira.structure.api.attribute.loader.basic.AbstractPropagateLoader;
import com.almworks.jira.structure.api.row.StructureRow;
import java.util.Collections;
import java.util.Set;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InheritedValueLoader<T>
extends AbstractPropagateLoader<T> {
    private final AttributeSpec<T> myValueSpec;
    private final boolean myForceParentValue;

    public InheritedValueLoader(AttributeSpec<T> spec, @NotNull AttributeSpec<T> valueSpec, boolean forceParentValue) {
        super(spec);
        this.myValueSpec = valueSpec;
        this.myForceParentValue = forceParentValue;
    }

    @Override
    public Set<AttributeSpec<?>> getAttributeDependencies() {
        return Collections.singleton(this.myValueSpec);
    }

    @Override
    @Nullable
    public BiFunction<StructureRow, PropagateAttributeContext, AttributeValue<T>> loadChildren(@NotNull AttributeValue<T> parentValue, @NotNull PropagateAttributeContext.Parent parentContext) {
        boolean allowChildValue = !this.myForceParentValue || !parentValue.isDefined();
        return (row, context) -> {
            AttributeValue<T> childValue = context.getDependencyAttributeValue(this.myValueSpec);
            return childValue.isDefined() && allowChildValue ? childValue : parentValue;
        };
    }
}

