/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.view;

import com.almworks.jira.structure.api.settings.StructurePage;
import com.atlassian.annotations.PublicApi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.annotate.JsonPropertyOrder;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@PublicApi
public class ViewSettings {
    public static final Set<StructurePage> NO_PAGES = Collections.emptySet();
    public static final Set<StructurePage> ALL_PAGES = Collections.unmodifiableSet(EnumSet.of(StructurePage.STRUCTURE_BOARD, StructurePage.ISSUE_VIEW, StructurePage.PROJECT_TAB, StructurePage.GADGET));
    public static final Set<StructurePage> PAGES_WITH_DEFAULT_VIEW = Collections.unmodifiableSet(EnumSet.of(StructurePage.STRUCTURE_BOARD, StructurePage.ISSUE_VIEW, StructurePage.PROJECT_TAB));
    public static final ViewSettings EMPTY_SETTINGS = new Builder().build();
    @Nullable
    private final List<AssociatedView> myAssociatedViews;

    private ViewSettings(@Nullable List<AssociatedView> associatedViews, boolean reuseList) {
        this.myAssociatedViews = associatedViews == null ? null : Collections.unmodifiableList(reuseList ? associatedViews : new ArrayList(associatedViews));
    }

    public boolean isDefined() {
        return this.myAssociatedViews != null;
    }

    @NotNull
    public List<AssociatedView> getAssociatedViews() {
        return this.myAssociatedViews == null ? Collections.emptyList() : this.myAssociatedViews;
    }

    @Nullable
    public Long getDefaultViewForPage(StructurePage page) {
        if (this.myAssociatedViews == null) {
            return null;
        }
        for (AssociatedView view : this.myAssociatedViews) {
            if (!view.isDefault(page)) continue;
            return view.getViewId();
        }
        return null;
    }

    public boolean hasView(Long viewId) {
        if (viewId == null || this.myAssociatedViews == null) {
            return false;
        }
        for (AssociatedView view : this.myAssociatedViews) {
            if (view.getViewId() != viewId.longValue()) continue;
            return true;
        }
        return false;
    }

    private static StructurePage adjustPage(StructurePage page) {
        if (page == StructurePage.COMPONENT_TAB || page == StructurePage.VERSION_TAB) {
            return StructurePage.PROJECT_TAB;
        }
        if (ALL_PAGES.contains((Object)page)) {
            return page;
        }
        return StructurePage.STRUCTURE_BOARD;
    }

    public String toString() {
        return "ViewSettings{associatedViews=" + this.myAssociatedViews + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ViewSettings that = (ViewSettings)o;
        return !(this.myAssociatedViews != null ? !this.myAssociatedViews.equals(that.myAssociatedViews) : that.myAssociatedViews != null);
    }

    public int hashCode() {
        return this.myAssociatedViews != null ? this.myAssociatedViews.hashCode() : 0;
    }

    public static class AssociatedView {
        private final long myViewId;
        @NotNull
        private final Set<StructurePage> myMenuPages;
        @NotNull
        private final Set<StructurePage> myDefaultPages;

        private AssociatedView(long viewId, @Nullable Set<StructurePage> menuPages, @Nullable Set<StructurePage> defaultPages) {
            this.myViewId = viewId;
            this.myMenuPages = menuPages == null ? ALL_PAGES : Collections.unmodifiableSet(menuPages);
            this.myDefaultPages = defaultPages == null ? NO_PAGES : Collections.unmodifiableSet(defaultPages);
        }

        @NotNull
        public Set<StructurePage> getMenuPages() {
            return this.myMenuPages;
        }

        @NotNull
        public Set<StructurePage> getDefaultPages() {
            return this.myDefaultPages;
        }

        public long getViewId() {
            return this.myViewId;
        }

        public boolean isOnMenu(StructurePage page) {
            return this.myMenuPages.contains((Object)ViewSettings.adjustPage(page));
        }

        public boolean isDefault(StructurePage page) {
            return this.myDefaultPages.contains((Object)ViewSettings.adjustPage(page));
        }

        public String toString() {
            return "ViewSettings.AssociatedView{viewId=" + this.myViewId + ", menuPages=" + this.myMenuPages + ", defaultPages=" + this.myDefaultPages + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AssociatedView that = (AssociatedView)o;
            if (this.myViewId != that.myViewId) {
                return false;
            }
            if (!this.myDefaultPages.equals(that.myDefaultPages)) {
                return false;
            }
            return this.myMenuPages.equals(that.myMenuPages);
        }

        public int hashCode() {
            int result = (int)(this.myViewId ^ this.myViewId >>> 32);
            result = 31 * result + this.myMenuPages.hashCode();
            result = 31 * result + this.myDefaultPages.hashCode();
            return result;
        }

        @XmlRootElement
        @JsonPropertyOrder(value={"view", "menuPages", "defaultPages"})
        @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
        public static class Builder {
            private long myViewId;
            private Set<StructurePage> myMenuPages;
            private Set<StructurePage> myDefaultPages;

            public Builder() {
            }

            public Builder(AssociatedView view) {
                if (view != null) {
                    this.myViewId = view.getViewId();
                    this.setMenuPages(view.getMenuPages());
                    this.setDefaultPages(view.getDefaultPages());
                }
            }

            public AssociatedView build() {
                if (!this.isValid()) {
                    return null;
                }
                return new AssociatedView(this.myViewId, this.myMenuPages, this.myDefaultPages);
            }

            @JsonIgnore
            private boolean isValid() {
                return this.myViewId != 0L;
            }

            @XmlElement
            @Nullable
            public Set<StructurePage> getMenuPages() {
                return StructurePage.enumSet(this.myMenuPages);
            }

            public void setMenuPages(@Nullable Set<StructurePage> menuPages) {
                this.myMenuPages = menuPages == null || menuPages.equals(ALL_PAGES) ? null : StructurePage.enumSet(menuPages);
                Builder.replaceDetailsPage(this.myMenuPages);
                Builder.validatePages(this.myMenuPages, ALL_PAGES);
            }

            @XmlElement
            @Nullable
            public Set<StructurePage> getDefaultPages() {
                return StructurePage.enumSet(this.myDefaultPages);
            }

            public void setDefaultPages(@Nullable Set<StructurePage> defaultPages) {
                this.myDefaultPages = StructurePage.enumSet(defaultPages);
                Builder.validatePages(this.myDefaultPages, PAGES_WITH_DEFAULT_VIEW);
            }

            @XmlElement
            @JsonProperty(value="view")
            public long getViewId() {
                return this.myViewId;
            }

            public void setViewId(long viewId) {
                this.myViewId = viewId;
            }

            private static void replaceDetailsPage(Set<StructurePage> pages) {
                if (pages != null && pages.remove((Object)StructurePage.STRUCTURE_BOARD_WITH_DETAILS)) {
                    pages.addAll(EnumSet.of(StructurePage.STRUCTURE_BOARD, StructurePage.PROJECT_TAB));
                }
            }

            private static void validatePages(Collection<StructurePage> pages, Set<StructurePage> universe) {
                if (pages == null) {
                    return;
                }
                pages.retainAll(universe);
            }

            public String toString() {
                return "ViewSettings.AssociatedView.Builder{viewId=" + this.myViewId + ", menuPages=" + this.myMenuPages + ", defaultPages=" + this.myDefaultPages + '}';
            }
        }
    }

    @XmlRootElement
    public static class Builder {
        private List<AssociatedView.Builder> myViews;

        public Builder() {
        }

        public Builder(@Nullable ViewSettings copyFrom) {
            if (copyFrom != null && copyFrom.isDefined()) {
                List<AssociatedView> copyViews = copyFrom.getAssociatedViews();
                this.myViews = new ArrayList<AssociatedView.Builder>(copyViews.size());
                for (AssociatedView view : copyViews) {
                    this.myViews.add(new AssociatedView.Builder(view));
                }
            }
        }

        @XmlElement
        @Nullable
        public List<AssociatedView.Builder> getViews() {
            return this.myViews == null ? null : new ArrayList<AssociatedView.Builder>(this.myViews);
        }

        public void setViews(List<AssociatedView.Builder> views) {
            this.myViews = views == null ? null : new ArrayList<AssociatedView.Builder>(views);
        }

        @NotNull
        public ViewSettings build() {
            ArrayList<AssociatedView> list = null;
            if (this.myViews != null) {
                list = new ArrayList<AssociatedView>(this.myViews.size());
                for (AssociatedView.Builder view : this.myViews) {
                    AssociatedView v = view.build();
                    if (v == null) continue;
                    list.add(v);
                }
            }
            return new ViewSettings(list, true);
        }

        public Builder addViews(long ... viewIds) {
            if (viewIds != null) {
                for (long viewId : viewIds) {
                    this.addView(viewId, false);
                }
            }
            return this;
        }

        public Builder addView(long viewId, boolean defaultView) {
            return this.addView(-1, viewId, null, defaultView ? PAGES_WITH_DEFAULT_VIEW : null);
        }

        public Builder addView(int index, long viewId, @Nullable Collection<StructurePage> menuPages, @Nullable Collection<StructurePage> defaultPages) {
            if (viewId <= 0L) {
                throw new IllegalArgumentException("cannot set parameters for view " + viewId);
            }
            this.makeDefined();
            if (index < 0) {
                index = this.myViews.size();
            } else if (index > this.myViews.size()) {
                throw new IndexOutOfBoundsException("bad index " + index);
            }
            for (int i = 0; i < this.myViews.size(); ++i) {
                AssociatedView.Builder builder = this.myViews.get(i);
                if (builder.getViewId() != viewId) continue;
                this.myViews.remove(i);
                if (index <= i) continue;
                --index;
            }
            AssociatedView.Builder builder = new AssociatedView.Builder();
            builder.setViewId(viewId);
            builder.setMenuPages(StructurePage.enumSet(menuPages));
            builder.setDefaultPages(StructurePage.enumSet(defaultPages));
            this.myViews.add(index, builder);
            return this;
        }

        public void makeDefined() {
            if (this.myViews == null) {
                this.myViews = new ArrayList<AssociatedView.Builder>(5);
            }
        }

        @JsonIgnore
        public boolean isDefined() {
            return this.myViews != null;
        }

        public String toString() {
            return "ViewSettings.Builder{views=" + this.myViews + '}';
        }
    }
}

