package com.almworks.jira.structure.api.attribute.loader;

import com.almworks.jira.structure.api.attribute.AttributeSpec;
import com.atlassian.annotations.PublicApi;
import org.jetbrains.annotations.Nullable;

/**
 * Provides context for the creation of attribute loaders.
 *
 * @see AttributeLoaderProvider
 */
@PublicApi
public interface AttributeProviderContext extends AttributeContext {
  /**
   * Tells the system to avoid caching the loader produced by the provider.
   */
  void mustNotCacheLoader();

  /**
   * <p>Checks if the attribute is based only on items, which means the value will not depend on a particular position
   * of the item in the forest. Such attributes may be used with {@link com.almworks.jira.structure.api.attribute.StructureAttributeService#getItemValues}.</p>
   *
   * <p>An attribute may change to item-based or to forest-based during runtime, if extension apps are installed.</p>
   *
   * <p>This method is the same as {@link com.almworks.jira.structure.api.attribute.StructureAttributeService#isItemAttribute}
   * and is supposed to be used by the providers to adjust the loaders based on whether dependent attributes
   * are item based or not.</p>
   *
   * @param attribute attribute
   * @return true if the attribute is item-based
   */
  boolean isItemAttribute(@Nullable AttributeSpec<?> attribute);
}
