package com.almworks.jira.structure.api.perfstats;

import com.almworks.jira.structure.api.util.La;
import com.atlassian.annotations.Internal;
import org.jetbrains.annotations.Nullable;

import java.util.Collection;
import java.util.List;

@Internal
public interface PerformanceLogProvider {
  @Nullable
  NodeInfo getLogs();

  static <T> List<NodeInfo> objectsToLeaves(Collection<T> elements) {
    return new La<T, NodeInfo>() {
      @Override
      public NodeInfo la(T argument) {
        return NodeInfo.leaf(argument.toString());
      }
    }.arrayList(elements);
  }
}
