package com.almworks.jira.structure.api.view;

/**
 * {@code RowDisplayMode} stores constants representing supported row display modes.
 * Display mode determines how rows heights are calculated in structure panel.
 */
public final class RowDisplayMode {
  private RowDisplayMode() {
  }

  /**
   * Fixed height rows that only show one line.
   */
  public static final int ONE_LINE = 11;

  /**
   * Adaptive row height to show all th row content.
   */
  public static final int TEXT_WRAPPING = 12;

  /**
   * @return true if the given column display mode is supported
   */
  public static boolean isValid(int mode) {
    return mode == ONE_LINE || mode == TEXT_WRAPPING;
  }
}