/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.effector;

import com.almworks.jira.structure.api.effector.EffectorFunction;
import com.almworks.jira.structure.api.util.I18nText;
import com.atlassian.annotations.PublicApi;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@PublicApi
public abstract class EffectorFunctionResponse {
    private EffectorFunctionResponse() {
    }

    public static EffectorFunctionResponse valid(@NotNull EffectorFunction effectorFunction) {
        return new Valid(effectorFunction);
    }

    public static EffectorFunctionResponse error(@NotNull String i18nKey, Object ... parameters) {
        return new Errors(Collections.singletonList(new I18nText(i18nKey, parameters)));
    }

    public static EffectorFunctionResponse errors(I18nText ... errors) {
        return new Errors(Arrays.asList(errors));
    }

    public static EffectorFunctionResponse errors(@NotNull List<I18nText> errors) {
        return new Errors(errors);
    }

    public static final class Errors
    extends EffectorFunctionResponse {
        @NotNull
        private final List<I18nText> myErrors;

        private Errors(@NotNull List<I18nText> errors) {
            if (errors.size() == 0) {
                throw new IllegalArgumentException("No errors in arguments");
            }
            this.myErrors = errors;
        }

        @NotNull
        public List<I18nText> getErrors() {
            return this.myErrors;
        }
    }

    public static final class Valid
    extends EffectorFunctionResponse {
        @NotNull
        private final EffectorFunction myEffectorFunction;

        private Valid(@NotNull EffectorFunction effectorFunction) {
            this.myEffectorFunction = effectorFunction;
        }

        @NotNull
        public EffectorFunction getEffectorFunction() {
            return this.myEffectorFunction;
        }
    }
}

