/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.export;

import com.atlassian.annotations.PublicApi;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@PublicApi
public enum ExportFormat {
    PRINTABLE("printable"),
    MS_EXCEL("ms-excel");

    private final String myExternalName;

    private ExportFormat(String externalName) {
        this.myExternalName = externalName;
    }

    @NotNull
    public String getExternalName() {
        return this.myExternalName;
    }

    @Nullable
    public static ExportFormat forExternalName(String externalName) {
        for (ExportFormat ef : ExportFormat.values()) {
            if (!ef.myExternalName.equals(externalName)) continue;
            return ef;
        }
        return null;
    }
}

