/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.settings;

import java.util.Collection;
import java.util.EnumSet;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlType;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonValue;
import org.jetbrains.annotations.Nullable;

@XmlType(name="structure-page")
@XmlEnum
public enum StructurePage {
    STRUCTURE_BOARD("structure"),
    STRUCTURE_BOARD_WITH_DETAILS("structure-with-details"),
    ISSUE_VIEW("issue"),
    PROJECT_TAB("project"),
    COMPONENT_TAB("component"),
    VERSION_TAB("version"),
    ISSUE_NAVIGATOR("navigator"),
    GADGET("gadget"),
    GREENHOPPER_TAB("greenhopper");

    private final String myId;

    private StructurePage(String id) {
        this.myId = id;
    }

    @JsonValue
    public String getId() {
        return this.myId;
    }

    @JsonCreator
    @Nullable
    public static StructurePage forId(@Nullable String id) {
        if (id == null) {
            return null;
        }
        for (StructurePage page : StructurePage.values()) {
            if (!id.equals(page.getId())) continue;
            return page;
        }
        return null;
    }

    @Nullable
    public static EnumSet<StructurePage> enumSet(@Nullable Collection<StructurePage> pages) {
        if (pages == null || pages.isEmpty()) {
            return null;
        }
        EnumSet<StructurePage> set = EnumSet.noneOf(StructurePage.class);
        set.addAll(pages);
        return set;
    }
}

