/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.generator;

import com.almworks.jira.structure.api.error.StructureException;
import com.almworks.jira.structure.api.forest.ForestSpec;
import com.almworks.jira.structure.api.forest.item.ItemForest;
import com.almworks.jira.structure.api.forest.item.ItemForestBuilder;
import com.almworks.jira.structure.api.forest.item.ItemListBuilder;
import com.almworks.jira.structure.api.generator.ActionEffect;
import com.almworks.jira.structure.api.generator.GeneratorUnavailableException;
import com.almworks.jira.structure.api.generator.ItemChangeFilter;
import com.almworks.jira.structure.api.generator.UpdateChecker;
import com.almworks.jira.structure.api.item.ItemIdentity;
import com.almworks.jira.structure.api.item.ItemVersionUpdate;
import com.almworks.jira.structure.api.pull.DataVersion;
import com.almworks.jira.structure.api.row.StructureRow;
import com.almworks.jira.structure.api.util.RunnableE;
import com.atlassian.annotations.PublicApi;
import com.atlassian.annotations.PublicSpi;
import com.atlassian.jira.util.ErrorCollection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@PublicSpi
public interface StructureGenerator {
    public void addDefaultFormParameters(@NotNull Map<String, Object> var1) throws GeneratorUnavailableException;

    public void addParametersToForm(@NotNull Map<String, Object> var1, @NotNull Map<String, Object> var2) throws GeneratorUnavailableException;

    @NotNull
    public Map<String, Object> buildParametersFromForm(@NotNull Map<String, Object> var1, @NotNull ErrorCollection var2) throws GeneratorUnavailableException;

    public void addParametersForSummary(@NotNull Map<String, Object> var1, @NotNull Map<String, Object> var2);

    public boolean isAvailable();

    @PublicSpi
    public static interface ApplicabilityChecker {
        public boolean isApplicableTo(StructureRow var1);
    }

    @PublicApi
    public static interface ItemChangeFilterContext
    extends Context {
        @Nullable
        public <T> T resolveItem(@NotNull ItemIdentity var1, @NotNull Class<T> var2);
    }

    @PublicApi
    public static interface EffectContext
    extends Context {
        public void block(String var1);

        public void yield(String var1);

        public void effect(String var1, RunnableE<? extends StructureException> var2);
    }

    @PublicApi
    public static interface HandlingContext
    extends Context {
        public void block(String var1);

        public void yield(String var1);

        public void effect(ActionEffect var1, ActionEffect var2);

        public Map<String, Object> parameters();

        public void putObject(@Nullable Object var1, @Nullable Object var2);

        @Nullable
        public <T> T getObject(@Nullable Object var1);
    }

    @PublicApi
    public static interface GenerationContext
    extends Context {
        public void addItemChangeFilter(ItemChangeFilter var1);

        public void addUpdateChecker(UpdateChecker var1);

        @NotNull
        public ItemForest previewForest();

        @Nullable
        public ForestSpec getForestSpecBeingTransformed();

        @NotNull
        public ItemVersionUpdate itemsUpdate();

        @NotNull
        public ItemVersionUpdate itemsUpdate(DataVersion var1);

        public void putObject(@Nullable Object var1, @Nullable Object var2);

        @Nullable
        public <T> T getObject(@Nullable Object var1);

        public void putTempObject(@Nullable Object var1, @Nullable Object var2);

        @Nullable
        public <T> T getTempObject(@Nullable Object var1);

        @NotNull
        public ForestSpec getForestSpec();

        public boolean isStopped();
    }

    @PublicApi
    public static interface Context {
    }

    @PublicSpi
    public static interface Sorter
    extends StructureGenerator {
        @Nullable
        public ApplicabilityChecker getApplicabilityChecker(@NotNull Map<String, Object> var1, @NotNull Context var2);

        @Nullable
        public CompareFunction getCompareFunction(@NotNull Map<String, Object> var1, @NotNull GenerationContext var2);

        @PublicSpi
        public static interface CompareFunction {
            public int compare(@NotNull StructureRow var1, @NotNull StructureRow var2);
        }
    }

    @PublicSpi
    public static interface Filter
    extends StructureGenerator {
        @Nullable
        public FilterFunction getFilterFunction(@NotNull Map<String, Object> var1, @NotNull GenerationContext var2);

        @PublicSpi
        public static interface FilterFunction {
            public boolean matches(@NotNull StructureRow var1);
        }
    }

    @PublicSpi
    public static interface Grouper
    extends StructureGenerator {
        @Nullable
        public GrouperFunction createGrouperFunction(@NotNull Map<String, Object> var1, @NotNull GenerationContext var2);

        @Nullable
        public String getSemanticLabel(@NotNull Map<String, Object> var1);

        @PublicSpi
        public static interface GrouperFunction {
            public Set<ItemIdentity> getGroups(@NotNull StructureRow var1);

            public boolean isExclusiveGroup(@NotNull ItemIdentity var1);

            public void createGroupRows(Set<ItemIdentity> var1, @NotNull ItemListBuilder var2);
        }
    }

    @PublicSpi
    public static interface Extender
    extends StructureGenerator {
        @Nullable
        public ExtenderFunction getExtenderFunction(@NotNull Map<String, Object> var1, @NotNull GenerationContext var2);

        @PublicSpi
        public static interface ExtenderFunction
        extends ApplicabilityChecker {
            public void extend(@NotNull StructureRow var1, @NotNull ItemForestBuilder var2);
        }
    }

    @PublicSpi
    public static interface Inserter
    extends StructureGenerator {
        public void createFragment(@NotNull Map<String, Object> var1, @NotNull GenerationContext var2, @NotNull ItemForestBuilder var3);
    }
}

