/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.forest;

import com.almworks.jira.structure.api.forest.ForestChange;
import com.almworks.jira.structure.api.forest.ForestSourceHealthStatus;
import com.almworks.jira.structure.api.forest.VersionedForest;
import com.almworks.jira.structure.api.pull.VersionedDataUpdate;
import com.atlassian.annotations.PublicApi;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@PublicApi
public abstract class VersionedForestUpdate
extends VersionedDataUpdate {
    @NotNull
    private final VersionedForest myLatest;
    @NotNull
    private final ForestSourceHealthStatus myHealth;

    private VersionedForestUpdate(@NotNull VersionedForest latest, @NotNull ForestSourceHealthStatus health) {
        super(latest.getVersion());
        this.myLatest = latest;
        this.myHealth = health;
    }

    @NotNull
    public VersionedForest getLatest() {
        return this.myLatest;
    }

    @NotNull
    public Incremental asIncremental() {
        return (Incremental)this;
    }

    @NotNull
    public ForestSourceHealthStatus getHealth() {
        return this.myHealth;
    }

    public static final class Incremental
    extends VersionedForestUpdate {
        @NotNull
        private final List<ForestChange> myUpdates;

        public Incremental(VersionedForest latest, @NotNull List<ForestChange> updates, ForestSourceHealthStatus health) {
            super(latest, health);
            if (updates == null) {
                throw new IllegalArgumentException("updates cannot be null");
            }
            this.myUpdates = updates;
        }

        public Incremental(VersionedForest latest, @NotNull List<ForestChange> updates) {
            this(latest, updates, ForestSourceHealthStatus.HEALTHY);
        }

        @NotNull
        public List<ForestChange> getUpdates() {
            return this.myUpdates;
        }

        @Override
        public boolean isEmpty() {
            return this.myUpdates.isEmpty();
        }
    }

    public static final class Full
    extends VersionedForestUpdate {
        public Full(VersionedForest latest, ForestSourceHealthStatus health) {
            super(latest, health);
        }

        public Full(VersionedForest latest) {
            super(latest, ForestSourceHealthStatus.HEALTHY);
        }

        @Override
        public boolean isFull() {
            return true;
        }
    }
}

