/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.sync;

import com.almworks.jira.structure.api.sync.IncrementalSyncData;
import com.almworks.jira.structure.api.sync.SyncEvent;
import com.almworks.jira.structure.api.sync.SyncEvents;
import com.almworks.jira.structure.api.sync.SyncInstance;
import com.almworks.jira.structure.api.util.La;
import com.almworks.jira.structure.api.util.MapObject;
import com.almworks.jira.structure.api.util.StructureUtil;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.fields.CustomField;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SyncAuditLogHelper {
    public static final La<Long, Map<String, Object>> ISSUE_INFO = new La<Long, Map<String, Object>>(){

        @Override
        public Map<String, Object> la(Long issueId) {
            return SyncAuditLogHelper.issueInfo(issueId);
        }
    };

    @NotNull
    public static Map<String, Object> issueInfo(@Nullable Issue issue) {
        if (issue == null) {
            return Collections.emptyMap();
        }
        return SyncAuditLogHelper.issueInfo(issue.getId(), issue.getKey());
    }

    @NotNull
    public static Map<String, Object> issueInfo(long issueId) {
        return SyncAuditLogHelper.issueInfo(issueId, StructureUtil.getDebugIssueKey(issueId));
    }

    @NotNull
    public static Map<String, Object> issueInfo(long issueId, @Nullable String key) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (key != null) {
            builder.put((Object)"key", (Object)key);
        }
        builder.put((Object)"id", (Object)issueId);
        return builder.build();
    }

    @NotNull
    public static Map<String, Object> issueConstantInfo(IssueConstant ic) {
        if (ic == null) {
            return Collections.emptyMap();
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (ic.getName() != null) {
            builder.put((Object)"name", (Object)ic.getName());
        }
        if (ic.getId() != null) {
            builder.put((Object)"id", (Object)ic.getId());
        }
        return builder.build();
    }

    @NotNull
    public static Map<String, Object> customFieldInfo(CustomField field) {
        if (field == null) {
            return Collections.emptyMap();
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (field.getName() != null) {
            builder.put((Object)"name", (Object)field.getName());
        }
        if (field.getIdAsLong() != null) {
            builder.put((Object)"id", (Object)field.getIdAsLong());
        }
        return builder.build();
    }

    @NotNull
    public static MapObject createAuditLogEntryDescription(SyncInstance instance, IncrementalSyncData data, Map<String, Object> aux) {
        ImmutableMap.Builder map = ImmutableMap.builder();
        map.put((Object)"action", (Object)(data == null ? "resync" : "sync"));
        map.putAll(aux);
        map.put((Object)"ownerKey", (Object)instance.getUserKey());
        map.put((Object)"parameters", StructureUtil.nnv(instance.getParameters(), Collections.emptyMap()));
        if (data != null) {
            map.put((Object)"jiraEvents", SyncEvents.JIRA_EVENT_TO_MAP.arrayList((Collection<SyncEvent.Jira>)data.getJiraEvents()));
            map.put((Object)"structureEvents", SyncEvents.STRUCTURE_EVENT_TO_MAP.arrayList((Collection<SyncEvent.Structure>)data.getStructureEvents()));
        }
        return new MapObject((Map<String, Object>)map.build());
    }

    public static ImmutableMap<String, Object> getFailureDescription(@Nullable String reason, @Nullable Throwable throwable) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"result", (Object)"failure");
        if (reason != null) {
            builder.put((Object)"reason", (Object)reason);
        }
        if (throwable != null) {
            builder.put((Object)"exception", SyncAuditLogHelper.getThrowableDescription(throwable));
        }
        return builder.build();
    }

    private static Map<String, Object> getThrowableDescription(Throwable throwable) {
        ImmutableMap.Builder throwableDescBuilder = ImmutableMap.builder();
        if (throwable.getMessage() != null) {
            throwableDescBuilder.put((Object)"message", (Object)throwable.getMessage());
        }
        throwableDescBuilder.put((Object)"class", (Object)throwable.getClass().getName()).put((Object)"stackTrace", Arrays.asList(throwable.getStackTrace()));
        if (throwable.getCause() != null) {
            throwableDescBuilder.put((Object)"cause", SyncAuditLogHelper.getThrowableDescription(throwable.getCause()));
        }
        return throwableDescBuilder.build();
    }

    public static boolean isFailed(MapObject action) {
        return "failure".equals(action.getString("result"));
    }
}

