package com.almworks.jira.structure.gantt.apiclient;

import com.almworks.structure.gantt.api.baseline.Baseline;
import com.almworks.structure.gantt.api.baseline.GanttBaselineException;
import com.almworks.structure.gantt.api.gantt.GanttChart;
import com.almworks.structure.gantt.api.gantt.GanttChartException;
import com.atlassian.jira.web.action.JiraWebActionSupport;

import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.request.RequestMethod;
import java.util.List;

import static java.util.Collections.emptyList;

@SupportedMethods({RequestMethod.GET, RequestMethod.POST})
public class GanttApiClient extends JiraWebActionSupport {
  private final TestComponent myComponent;

  public GanttApiClient(TestComponent component) {
    myComponent = component;
  }

  public List<Baseline> getBaselines() {
    try {
      Long ganttId = getGanttId();
      if (ganttId != null) {
        return myComponent.getBaselineManager().getBaselines(ganttId);
      } else {
        return emptyList();
      }
    } catch (GanttBaselineException e) {
      return emptyList();
    }
  }

  public Long getGanttId() {
    String ganttIdString = getHttpRequest().getParameter("ganttId");
    if (ganttIdString != null) {
      return Long.parseLong(ganttIdString);
    }
    return null;
  }

  public Long getBaselineId() {
    String baselineId = getHttpRequest().getParameter("baselineId");
    if (baselineId != null) {
      return Long.parseLong(baselineId);
    }
    return null;
  }

  public List<GanttChart> getGanttCharts() {
    try {
      return myComponent.getMyGanttChartManager().getAllGanttCharts();
    } catch (GanttChartException e) {
      return emptyList();
    }
  }

  public String doExecute() {
    return SUCCESS;
  }
}
