/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.attribute.loader.basic;

import com.almworks.jira.structure.api.attribute.AttributeSpec;
import com.almworks.jira.structure.api.attribute.AttributeValue;
import com.almworks.jira.structure.api.attribute.loader.AttributeLoader;
import com.almworks.jira.structure.api.attribute.loader.DerivedAttributeContext;
import com.almworks.jira.structure.api.attribute.loader.basic.AbstractDerivedAttributeLoader;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SimpleDerivedAttributeLoader<T, D>
extends AbstractDerivedAttributeLoader<T> {
    protected final AttributeSpec<? extends D> myDependency;
    private final boolean myYield;

    protected SimpleDerivedAttributeLoader(AttributeSpec<T> spec, AttributeSpec<? extends D> dependency) {
        this(spec, dependency, true);
    }

    protected SimpleDerivedAttributeLoader(AttributeSpec<T> spec, AttributeSpec<? extends D> dependency, boolean yield) {
        super(spec);
        this.myDependency = dependency;
        this.myYield = yield;
    }

    @Override
    public final Set<AttributeSpec<?>> getAttributeDependencies() {
        return Collections.singleton(this.myDependency);
    }

    @Override
    public AttributeValue<T> loadValue(DerivedAttributeContext context) {
        T value;
        AttributeValue<D> dependentResult = context.getDependencyAttributeValue(this.myDependency);
        D dependentValue = dependentResult.getValue();
        Object result = dependentValue == null ? (this.myYield ? null : dependentResult.cast(this.getAttributeSpec())) : ((value = this.getValue(dependentValue, context)) == null && this.myYield ? null : AttributeValue.ofNullable(value));
        return result;
    }

    @Nullable
    protected abstract T getValue(@NotNull D var1, DerivedAttributeContext var2);

    public static <T> AttributeLoader<T> idLoader(AttributeSpec<T> spec, AttributeSpec<T> dependency) {
        if (spec.getFormat() != dependency.getFormat()) {
            return null;
        }
        return new SimpleDerivedAttributeLoader<T, T>((AttributeSpec)spec, dependency){

            @Override
            protected T getValue(@NotNull T value, DerivedAttributeContext context) {
                return value;
            }
        };
    }
}

