/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.structure.history;

import com.almworks.integers.LongArray;
import com.almworks.integers.LongIterator;
import com.almworks.integers.LongList;
import com.almworks.jira.structure.api.item.ItemIdentity;
import com.almworks.jira.structure.api.structure.history.HistoryEntry;
import com.almworks.jira.structure.api.util.ToString;
import com.google.common.collect.ImmutableSet;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HistoryQuery {
    public static final List<HistoryEntry.Operation> ALL_OPERATIONS = Collections.unmodifiableList(Arrays.asList(HistoryEntry.Operation.values()));
    @Nullable
    public final Set<HistoryEntry.Operation> operations;
    @NotNull
    public final LongList isIssuesSorted;
    @NotNull
    public final LongList notIssuesSorted;
    @NotNull
    public final LongList isStructuresSorted;
    @NotNull
    public final LongList notStructuresSorted;
    @NotNull
    public final Set<String> isAuthors;
    @NotNull
    public final Set<String> notAuthors;
    @NotNull
    public final LongList isProjectsSorted;
    @NotNull
    public final LongList notProjectsSorted;
    @NotNull
    public final LongList isSynchronizersSorted;
    @NotNull
    public final LongList notSynchronizersSorted;
    @NotNull
    public final Set<ItemIdentity> isAncestors;
    @NotNull
    public final Set<ItemIdentity> notAncestors;
    @Nullable
    public final Long minDate;
    @Nullable
    public final Long maxDate;
    @Nullable
    public final Long startId;
    private volatile String myStringRepresentation;

    public HistoryQuery(Iterable<HistoryEntry.Operation> operations, LongList isIssuesSorted, LongList notIssuesSorted, LongList isStructuresSorted, LongList notStructuresSorted, Iterable<String> isAuthors, Iterable<String> notAuthors, LongList isProjectsSorted, LongList notProjectsSorted, LongList isSynchronizersSorted, LongList notSynchronizersSorted, Set<ItemIdentity> isAncestors, Set<ItemIdentity> notAncestors, Date minDate, Date maxDate, @Nullable Long startId) {
        Set<HistoryEntry.Operation> typeSet = HistoryQuery.set(operations);
        this.operations = typeSet.containsAll(ALL_OPERATIONS) ? null : typeSet;
        this.isIssuesSorted = HistoryQuery.nn(isIssuesSorted);
        this.notIssuesSorted = HistoryQuery.nn(notIssuesSorted);
        this.isStructuresSorted = HistoryQuery.nn(isStructuresSorted);
        this.notStructuresSorted = HistoryQuery.nn(notStructuresSorted);
        this.isAuthors = HistoryQuery.set(isAuthors);
        this.notAuthors = HistoryQuery.set(notAuthors);
        this.isProjectsSorted = HistoryQuery.nn(isProjectsSorted);
        this.notProjectsSorted = HistoryQuery.nn(notProjectsSorted);
        this.isSynchronizersSorted = HistoryQuery.nn(isSynchronizersSorted);
        this.notSynchronizersSorted = HistoryQuery.nn(notSynchronizersSorted);
        this.isAncestors = HistoryQuery.set(isAncestors);
        this.notAncestors = HistoryQuery.set(notAncestors);
        this.minDate = minDate != null ? Long.valueOf(minDate.getTime()) : null;
        this.maxDate = maxDate != null ? Long.valueOf(maxDate.getTime()) : null;
        this.startId = startId;
    }

    public HistoryQuery(long structureId, Long startId) {
        this(ALL_OPERATIONS, null, null, (LongList)LongArray.create((long[])new long[]{structureId}), null, null, null, null, null, null, null, null, null, null, null, startId);
    }

    private static LongList nn(LongList list) {
        return list == null ? LongList.EMPTY : list;
    }

    private static <T> Set<T> set(Iterable<T> it) {
        return it == null ? ImmutableSet.of() : ImmutableSet.copyOf(it);
    }

    public String toString() {
        String s = this.myStringRepresentation;
        if (s != null) {
            return s;
        }
        StringBuilder sb = ToString.begin("query");
        this.append(sb, "types", this.operations);
        this.append(sb, "structures+", this.isStructuresSorted);
        this.append(sb, "structures-", this.notStructuresSorted);
        this.append(sb, "issues+", this.isIssuesSorted);
        this.append(sb, "issues-", this.notIssuesSorted);
        this.append(sb, "users+", this.isAuthors);
        this.append(sb, "users-", this.notAuthors);
        this.append(sb, "projects+", this.isProjectsSorted);
        this.append(sb, "projects-", this.notProjectsSorted);
        this.append(sb, "syncs+", this.isSynchronizersSorted);
        this.append(sb, "syncs-", this.notSynchronizersSorted);
        this.append(sb, "ancestors+", this.isAncestors);
        this.append(sb, "ancestors-", this.notAncestors);
        if (this.minDate != null || this.maxDate != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US);
            if (this.minDate != null) {
                ToString.append(sb, "from", dateFormat.format(new Date(this.minDate)));
            }
            if (this.maxDate != null) {
                ToString.append(sb, "until", dateFormat.format(new Date(this.maxDate)));
            }
        }
        if (this.startId != null) {
            sb.append("startId").append("=").append(this.startId);
        }
        this.myStringRepresentation = s = ToString.end(sb);
        return s;
    }

    private void append(StringBuilder sb, String name, Collection c) {
        if (c != null && !c.isEmpty()) {
            ToString.append(sb, name, c);
        }
    }

    private void append(StringBuilder sb, String name, LongList list) {
        if (list != null && !list.isEmpty()) {
            sb.append(name).append("=");
            String sep = "(";
            for (LongIterator ii : list) {
                sb.append(sep).append(ii.value());
                sep = ",";
            }
            sb.append(")").append(",");
        }
    }
}

