/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class ComparableTuple
implements Comparable<ComparableTuple> {
    public static final ComparableTuple NIL = new ComparableTuple(new Object[0]);
    @NotNull
    private final Object[] myValue;

    private ComparableTuple(@NotNull Object[] value) {
        this.myValue = value;
    }

    public static ComparableTuple of(long number) {
        return new ComparableTuple(new Object[]{number});
    }

    public static ComparableTuple of(double number) {
        return new ComparableTuple(new Object[]{number});
    }

    public static ComparableTuple of(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        return new ComparableTuple(new Object[]{string});
    }

    public static ComparableTuple of(String a, String b) {
        if (a == null || b == null) {
            throw new IllegalArgumentException();
        }
        return new ComparableTuple(new Object[]{a, b});
    }

    public static ComparableTuple of(long a, long b) {
        return new ComparableTuple(new Object[]{a, b});
    }

    public static ComparableTuple of(String[] strings) {
        if (strings == null) {
            throw new IllegalArgumentException();
        }
        return new ComparableTuple(Arrays.copyOf(strings, strings.length));
    }

    public static ComparableTuple of(Long[] longs) {
        if (longs == null) {
            throw new IllegalArgumentException();
        }
        return new ComparableTuple(Arrays.copyOf(longs, longs.length));
    }

    public static ComparableTuple of(String a, long b) {
        if (a == null) {
            throw new IllegalArgumentException();
        }
        return new ComparableTuple(new Object[]{a, b});
    }

    public static ComparableTuple of(String a, long b, String c) {
        if (a == null || c == null) {
            throw new IllegalArgumentException();
        }
        return new ComparableTuple(new Object[]{a, b, c});
    }

    public static ComparableTuple of(List<?> values) {
        if (values == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<Object> list = new ArrayList<Object>(values.size());
        for (Object v : values) {
            if (v == null) {
                throw new IllegalArgumentException();
            }
            if (v instanceof String || v instanceof Number) {
                list.add(v);
                continue;
            }
            if (v instanceof ComparableTuple) {
                list.addAll(Arrays.asList(((ComparableTuple)v).myValue));
                continue;
            }
            throw new IllegalArgumentException();
        }
        return new ComparableTuple(list.toArray(new Object[list.size()]));
    }

    @Override
    public int compareTo(@NotNull ComparableTuple other) {
        int len1 = this.myValue.length;
        int len2 = other.myValue.length;
        int len = Math.min(len1, len2);
        for (int i = 0; i < len; ++i) {
            int r = this.compareElement(this.myValue[i], other.myValue[i]);
            if (r == 0) continue;
            return r;
        }
        return len1 == len2 ? 0 : (len1 < len2 ? -1 : 1);
    }

    private int compareElement(Object a, Object b) {
        if (a instanceof String) {
            if (b instanceof String) {
                return ((String)a).compareTo((String)b);
            }
            return 1;
        }
        if (b instanceof String) {
            return -1;
        }
        return this.compareNumbers((Number)a, (Number)b);
    }

    private int compareNumbers(Number a, Number b) {
        double d2;
        long v2;
        long v1 = a.longValue();
        if (v1 != (v2 = b.longValue())) {
            return v1 < v2 ? -1 : 1;
        }
        double d1 = a.doubleValue();
        if (d1 != (d2 = b.doubleValue())) {
            return d1 < d2 ? -1 : 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComparableTuple that = (ComparableTuple)o;
        return this.compareTo(that) == 0;
    }

    public int hashCode() {
        int r = 0;
        for (Object v : this.myValue) {
            r = v instanceof String ? r * 31 + v.hashCode() : r * 31 + new Double(((Number)v).doubleValue()).hashCode();
        }
        return r;
    }

    public String toString() {
        StringBuilder r = new StringBuilder("(");
        String prefix = "";
        for (Object v : this.myValue) {
            r.append(prefix);
            if (v instanceof String) {
                r.append('\'').append(v).append('\'');
            } else {
                r.append(v);
            }
            prefix = ",";
        }
        r.append(')');
        return r.toString();
    }
}

