/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.attribute;

import com.atlassian.annotations.Internal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Internal
public class AttributeSpecNormalization {
    @NotNull
    public static Map<String, Object> normalizeParams(@NotNull Map<String, Object> specParams) {
        if (!AttributeSpecNormalization.isNormalizationNeeded(specParams.values(), true)) {
            return specParams;
        }
        return AttributeSpecNormalization.normalizeMap(specParams);
    }

    @NotNull
    private static Map<String, Object> normalizeMap(@NotNull Map<String, Object> specParams) {
        if (specParams.isEmpty()) {
            return specParams;
        }
        LinkedHashMap<String, Object> r = new LinkedHashMap<String, Object>(specParams.size());
        for (Map.Entry<String, Object> e : specParams.entrySet()) {
            Object value = AttributeSpecNormalization.normalizeValue(e.getValue());
            if (AttributeSpecNormalization.isValueRemoved(value)) continue;
            r.put(e.getKey(), value);
        }
        return r;
    }

    private static List<Object> normalizeList(@NotNull List<Object> list) {
        if (list.isEmpty()) {
            return list;
        }
        ArrayList<Object> r = new ArrayList<Object>(list.size());
        for (Object value : list) {
            r.add(AttributeSpecNormalization.normalizeValue(value));
        }
        return r;
    }

    @Nullable
    private static Object normalizeValue(Object value) {
        if (value instanceof Map) {
            return AttributeSpecNormalization.normalizeMap((Map)value);
        }
        if (value instanceof List) {
            return AttributeSpecNormalization.normalizeList((List)value);
        }
        return value;
    }

    private static boolean isNormalizationNeeded(@NotNull Collection<Object> values, boolean canRemoveValue) {
        for (Object value : values) {
            if (!AttributeSpecNormalization.isValueNormalizationNeeded(value, canRemoveValue)) continue;
            return true;
        }
        return false;
    }

    private static boolean isValueNormalizationNeeded(Object value, boolean canRemoveValue) {
        if (canRemoveValue && AttributeSpecNormalization.isValueRemoved(value)) {
            return true;
        }
        if (value instanceof List && AttributeSpecNormalization.isNormalizationNeeded((List)value, false)) {
            return true;
        }
        return value instanceof Map && AttributeSpecNormalization.isNormalizationNeeded(((Map)value).values(), true);
    }

    private static boolean isValueRemoved(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof Boolean && !((Boolean)value).booleanValue()) {
            return true;
        }
        if (value instanceof Integer && (Integer)value == 0) {
            return true;
        }
        if (value instanceof Long && (Long)value == 0L) {
            return true;
        }
        if (value instanceof List && ((List)value).isEmpty()) {
            return true;
        }
        return value instanceof Map && ((Map)value).isEmpty();
    }
}

