/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.attribute.loader;

import com.almworks.jira.structure.api.attribute.AttributeSpec;
import com.almworks.jira.structure.api.attribute.loader.AbstractForestIndependentAttributeLoader;
import com.almworks.jira.structure.api.attribute.loader.AttributeLoader;
import com.almworks.jira.structure.api.attribute.loader.AttributeValue;
import com.almworks.jira.structure.api.row.StructureRow;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class ItemTypeAttributeLoader<A>
extends AbstractForestIndependentAttributeLoader<A> {
    protected final Set<String> myItemTypes;

    public ItemTypeAttributeLoader(AttributeSpec<A> spec, String ... itemTypes) {
        super(spec);
        if (itemTypes == null || itemTypes.length == 0) {
            throw new IllegalArgumentException("empty or null item types");
        }
        this.myItemTypes = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(itemTypes)));
    }

    @Override
    public final boolean isEveryItemTypeSupported() {
        return false;
    }

    @Override
    public final boolean isItemTypeSupported(String itemType) {
        return this.myItemTypes.contains(itemType);
    }

    @Override
    @NotNull
    public AttributeValue<A> loadValue(@NotNull StructureRow row, @NotNull AttributeLoader.Context context) {
        if (this.myItemTypes.contains(row.getItemId().getItemType())) {
            return this.getItemValue(row, context);
        }
        return AttributeValue.undefined();
    }

    protected abstract AttributeValue<A> getItemValue(@NotNull StructureRow var1, @NotNull AttributeLoader.Context var2);
}

