/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.attribute.loader;

import com.almworks.jira.structure.api.attribute.AttributeSpec;
import com.almworks.jira.structure.api.attribute.loader.AttributeContext;
import com.almworks.jira.structure.api.attribute.loader.AttributeLoader;
import com.almworks.jira.structure.api.attribute.loader.AttributeLoaderProvider;
import com.almworks.jira.structure.api.attribute.loader.CompositeAttributeLoader;
import com.almworks.jira.structure.api.error.StructureProviderException;
import com.almworks.jira.structure.api.util.StructureUtil;
import com.atlassian.annotations.Internal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Internal
public abstract class SimpleAttributeProvider
implements AttributeLoaderProvider {
    private final Map<String, List<AttributeLoader<?>>> myLoaders = new HashMap();

    protected final void registerLoader(AttributeLoader<?> loader) {
        AttributeSpec<?> spec = loader.getAttributeSpec();
        this.myLoaders.computeIfAbsent(spec.getId(), id -> new ArrayList(2)).add(loader);
    }

    @SafeVarargs
    protected final <T> void registerCompositeLoader(AttributeSpec<T> spec, AttributeLoader<T> ... loaders) {
        this.registerLoader(CompositeAttributeLoader.create(spec, Arrays.asList(loaders)));
    }

    @Override
    @Nullable
    public synchronized AttributeLoader<?> createAttributeLoader(@NotNull AttributeSpec<?> spec, @NotNull AttributeContext context) throws StructureProviderException {
        List<AttributeLoader<?>> loaders = this.myLoaders.get(spec.getId());
        if (loaders == null) {
            return null;
        }
        return loaders.stream().filter(l -> StructureUtil.isSubMap(spec.getParamsMap(), l.getAttributeSpec().getParamsMap())).sorted(Comparator.comparingInt(l -> -l.getAttributeSpec().getParamsMap().size()).thenComparingInt(l -> l.getAttributeSpec().is(spec.getFormat()) ? 0 : 1)).findFirst().orElse(null);
    }
}

