/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.attribute.loader.basic;

import com.almworks.jira.structure.api.attribute.loader.AttributeValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NumberAccumulator {
    private static final MathContext MC = MathContext.DECIMAL64;
    private long myLongValue;
    private double myDoubleValue;
    private boolean myDefined;
    private boolean myFloating;
    private BigDecimal myBigDecimal;
    private double myDoubleSumCompensation = 0.0;
    private BigDecimal myBigDecimalCompensation = BigDecimal.ZERO;

    public void add(Number value) {
        this.addMultiply(value, 1);
    }

    public void remove(Number value) {
        this.addMultiply(value, -1);
    }

    public void removeMultiply(Number value, int count) {
        this.addMultiply(value, -count);
    }

    public void addMultiply(Number value, int count) {
        if (value == null) {
            return;
        }
        this.myDefined = true;
        BigDecimal bigValue = null;
        double doubleValue = 0.0;
        long longValue = 0L;
        boolean integral = false;
        if (value instanceof BigDecimal) {
            bigValue = (BigDecimal)value;
        } else if (value instanceof BigInteger) {
            bigValue = new BigDecimal((BigInteger)value);
        } else {
            doubleValue = value.doubleValue();
            boolean bl = integral = doubleValue == (double)(longValue = value.longValue());
        }
        if (bigValue != null && this.myBigDecimal == null) {
            this.switchToBigDecimal();
        }
        if (this.myBigDecimal != null) {
            this.addBigDecimal(bigValue, doubleValue, longValue, integral, count);
        } else {
            this.addPrimitive(doubleValue, longValue, integral, count);
        }
    }

    private void addPrimitive(double doubleValue, long longValue, boolean integral, int count) {
        if (!integral && !this.myFloating) {
            this.myFloating = true;
            this.myLongValue = 0L;
        }
        double add = (doubleValue *= (double)count) - this.myDoubleSumCompensation;
        double sum = this.myDoubleValue + add;
        this.myDoubleSumCompensation = sum - this.myDoubleValue - add;
        this.myDoubleValue = sum;
        if (!this.myFloating) {
            this.myLongValue += longValue * (long)count;
        }
    }

    private void addBigDecimal(BigDecimal bigValue, double doubleValue, long longValue, boolean integral, int count) {
        if (bigValue == null) {
            bigValue = integral ? new BigDecimal(longValue) : new BigDecimal(doubleValue, MC);
        }
        if (count != 1) {
            bigValue = bigValue.multiply(new BigDecimal(count), MC);
        }
        BigDecimal add = bigValue.subtract(this.myBigDecimalCompensation, MC);
        BigDecimal sum = this.myBigDecimal.add(add, MC);
        this.myBigDecimalCompensation = sum.subtract(this.myBigDecimal, MC).subtract(add, MC);
        this.myBigDecimal = sum;
    }

    private void switchToBigDecimal() {
        this.myBigDecimal = this.myFloating ? new BigDecimal(this.myDoubleValue, MC) : new BigDecimal(this.myLongValue);
        this.myLongValue = 0L;
        this.myDoubleValue = 0.0;
        this.myFloating = false;
    }

    @NotNull
    public AttributeValue<Number> toValue() {
        Number number = this.toNumber();
        return number == null ? AttributeValue.undefined() : AttributeValue.of(number);
    }

    @Nullable
    public Number toNumber() {
        if (!this.myDefined) {
            return null;
        }
        if (this.myBigDecimal == null) {
            if (this.myFloating) {
                return this.myDoubleValue;
            }
            return this.myLongValue;
        }
        return this.myBigDecimal.stripTrailingZeros();
    }

    public String toString() {
        String val = !this.myDefined ? "" : (this.myBigDecimal != null ? this.myBigDecimal.stripTrailingZeros().toPlainString() : (this.myFloating ? this.myDoubleValue + "D" : this.myLongValue + "L"));
        return "NumberAccumulator[" + val + "]";
    }
}

