/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.perfstats;

import com.google.common.collect.Collections2;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import javax.annotation.Nullable;

public class NodeInfo {
    protected final String myTitle;

    public NodeInfo(String title) {
        this.myTitle = title;
    }

    public String getTitle() {
        return this.myTitle;
    }

    public Collection<NodeInfo> getNodes() {
        return Collections.emptyList();
    }

    public boolean isBranch() {
        return false;
    }

    public String toString() {
        return this.myTitle;
    }

    @Nullable
    public static Branch branch(String title, Collection<NodeInfo> nodes) {
        return nodes.isEmpty() ? null : new Branch(title, nodes);
    }

    public static Branch branch(String title, NodeInfo ... nodes) {
        return NodeInfo.branch(title, Arrays.asList(nodes));
    }

    public static NodeInfo leaf(String title) {
        return new NodeInfo(title);
    }

    public static class Branch
    extends NodeInfo {
        private final Collection<NodeInfo> myNodes;

        Branch(String title, Collection<NodeInfo> nodes) {
            super(title);
            this.myNodes = nodes;
        }

        @Override
        public Collection<NodeInfo> getNodes() {
            return Collections2.filter(this.myNodes, Objects::nonNull);
        }

        @Override
        public boolean isBranch() {
            return true;
        }
    }
}

