/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.permissions;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlEnum
@XmlType(name="level")
public enum PermissionLevel {
    NONE(0),
    VIEW(10),
    EDIT(20),
    EDIT_GENERATORS(25),
    ADMIN(30);

    private final int mySerial;

    private PermissionLevel(int serial) {
        this.mySerial = serial;
    }

    public int getSerial() {
        return this.mySerial;
    }

    public boolean includes(@Nullable PermissionLevel requiredPermission) {
        return requiredPermission == null || this.mySerial >= requiredPermission.getSerial();
    }

    @NotNull
    public static PermissionLevel fromSerial(int serial) {
        PermissionLevel r = NONE;
        for (PermissionLevel p : PermissionLevel.values()) {
            if (p.getSerial() > serial) break;
            r = p;
        }
        return r;
    }
}

