/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.row;

import com.almworks.jira.structure.api.item.ItemIdentity;
import com.almworks.jira.structure.api.item.ItemResolver;
import com.almworks.jira.structure.api.row.StructureRow;
import com.atlassian.annotations.Internal;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Internal
public final class SimpleRow
implements StructureRow {
    private final long myRowId;
    private final ItemIdentity myItemId;
    private final long mySemantics;
    private final ItemResolver myResolver;
    private volatile boolean myItemLoaded;
    private Object myItem;

    public SimpleRow(long rowId, ItemIdentity itemId, long semantics, ItemResolver resolver) {
        this.myRowId = rowId;
        this.myItemId = itemId;
        this.mySemantics = semantics;
        this.myResolver = resolver;
    }

    @Override
    public long getRowId() {
        return this.myRowId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public <I> I getItem(@NotNull Class<I> itemClass) {
        if (!this.myItemLoaded) {
            SimpleRow simpleRow = this;
            synchronized (simpleRow) {
                if (!this.myItemLoaded) {
                    try {
                        this.myItem = this.myResolver.resolveItem(this.getItemId(), Object.class);
                    }
                    finally {
                        this.myItemLoaded = true;
                    }
                }
            }
        }
        return itemClass.isInstance(this.myItem) ? (I)itemClass.cast(this.myItem) : null;
    }

    @Override
    @NotNull
    public ItemIdentity getItemId() {
        return this.myItemId;
    }

    @Override
    public long getSemantics() {
        return this.mySemantics;
    }

    public String toString() {
        return "SimpleRow[" + this.myRowId + ":" + this.myItemId + ":" + this.mySemantics + "]";
    }
}

