/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.structure;

import com.almworks.jira.structure.api.error.StructureException;
import com.almworks.jira.structure.api.permissions.PermissionLevel;
import com.almworks.jira.structure.api.permissions.PermissionRule;
import com.almworks.jira.structure.api.util.StructureUtil;
import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.user.ApplicationUser;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@PublicApi
public interface Structure {
    public long getId();

    @NotNull
    public String getName();

    @NotNull
    public String getDescription();

    @Nullable
    default public ApplicationUser getOwner() {
        return StructureUtil.getUserByKey(this.getOwnerUserKey());
    }

    @Nullable
    public String getOwnerUserKey();

    @NotNull
    public List<PermissionRule> getPermissions();

    public boolean isEditRequiresParentIssuePermission();

    public boolean isArchived();

    @NotNull
    public Structure setName(@Nullable String var1);

    @NotNull
    public Structure setDescription(@Nullable String var1);

    @NotNull
    default public Structure setOwner(@Nullable ApplicationUser owner) {
        this.setOwnerUserKey(StructureUtil.getUserKey(owner));
        return this;
    }

    @NotNull
    public Structure setOwnerUserKey(@Nullable String var1);

    @NotNull
    public Structure setPermissions(@Nullable Collection<? extends PermissionRule> var1);

    @NotNull
    public Structure setEditRequiresParentIssuePermission(boolean var1);

    @NotNull
    public Structure setArchived(boolean var1);

    @NotNull
    public Structure saveChanges() throws StructureException;

    @NotNull
    public PermissionLevel getEffectivePermission();
}

