/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.structure;

import com.almworks.jira.structure.api.error.StructureException;
import com.almworks.jira.structure.api.permissions.PermissionLevel;
import com.almworks.jira.structure.api.structure.Structure;
import com.almworks.jira.structure.api.structure.StructureListener;
import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.user.ApplicationUser;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@PublicApi
public interface StructureManager {
    @NotNull
    public Structure getStructure(@Nullable Long var1, @Nullable PermissionLevel var2) throws StructureException;

    @NotNull
    public List<Structure> getAllStructures(@Nullable PermissionLevel var1);

    @NotNull
    public List<Structure> getAllStructures(@Nullable PermissionLevel var1, boolean var2);

    @NotNull
    public List<Structure> getArchivedStructures(@Nullable PermissionLevel var1);

    @NotNull
    public List<Structure> getStructuresOwnedBy(@Nullable ApplicationUser var1);

    @NotNull
    public List<Structure> getStructuresByName(@Nullable String var1, @Nullable PermissionLevel var2);

    @NotNull
    public List<Structure> getStructuresByName(@Nullable String var1, @Nullable PermissionLevel var2, boolean var3);

    public boolean hasNonArchivedStructuresForUser();

    @Nullable
    public Long getSingleViewableStructureId();

    public boolean isIssueInStructureNoAccessCheck(@Nullable Long var1, @Nullable Long var2);

    @NotNull
    public List<Structure> getViewableStructuresWithIssue(@Nullable Long var1);

    @NotNull
    public PermissionLevel getStructurePermission(@Nullable Long var1);

    @NotNull
    public PermissionLevel getStructurePermission(@Nullable Long var1, @Nullable ApplicationUser var2);

    public boolean isAccessible(@Nullable Long var1, @Nullable PermissionLevel var2);

    public boolean isAutomationAccessAllowed(@Nullable Long var1, @Nullable ApplicationUser var2);

    @NotNull
    public Structure createStructure();

    @NotNull
    public Structure copyStructure(@Nullable Long var1, @Nullable ApplicationUser var2, boolean var3) throws StructureException;

    @NotNull
    public Structure copyStructureWithoutForest(@Nullable Long var1, @Nullable ApplicationUser var2, boolean var3) throws StructureException;

    public void deleteStructure(@Nullable Long var1) throws StructureException;

    public void addListener(@NotNull StructureListener var1);

    public void removeListener(@NotNull StructureListener var1);
}

