/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.util;

import com.almworks.integers.IntArray;
import com.almworks.integers.IntCollections;
import com.almworks.integers.IntIterator;
import com.almworks.integers.LongFindingIterator;
import com.almworks.integers.LongIterator;
import com.almworks.integers.WritableIntList;
import com.almworks.jira.structure.api.forest.raw.Forest;
import java.util.ArrayList;
import java.util.List;

public class IndexedForest {
    private final Forest myForest;
    private WritableIntList mySubtreeEnds;
    private WritableIntList mySubtreeStarts;
    private WritableIntList myParents;
    private List<WritableIntList> mySiblingBuffers;

    public IndexedForest(Forest forest) {
        this.myForest = forest;
    }

    public int subtreeEnd(int idx) {
        int end;
        if (idx < 0) {
            return this.size();
        }
        if (this.mySubtreeEnds == null) {
            this.mySubtreeEnds = new IntArray(IntCollections.repeat((int)-1, (int)this.myForest.size()));
        }
        if ((end = this.mySubtreeEnds.get(idx)) < 0) {
            end = this.calcSubtreeEnds(idx);
        }
        assert (end >= 0);
        return end;
    }

    private int calcSubtreeEnds(int i) {
        if (this.mySubtreeStarts == null) {
            this.mySubtreeStarts = new IntArray();
        } else {
            this.mySubtreeStarts.clear();
        }
        int n = this.myForest.size();
        int startDepth = this.myForest.getDepth(i);
        ++i;
        while (i < n + 1) {
            int lastDepth;
            int depth = i < n ? Math.max(this.myForest.getDepth(i) - startDepth, 0) : 0;
            if (depth > (lastDepth = this.mySubtreeStarts.size())) {
                this.mySubtreeStarts.add(i - 1);
            } else if (depth == lastDepth) {
                this.mySubtreeEnds.set(i - 1, i);
            } else {
                for (int j = lastDepth - 1; j >= depth; --j) {
                    this.mySubtreeEnds.set(this.mySubtreeStarts.get(j), i);
                }
                this.mySubtreeStarts.removeRange(depth, lastDepth);
            }
            if (depth == 0) {
                assert (this.mySubtreeStarts.isEmpty());
                return i;
            }
            ++i;
        }
        assert (false);
        return i + 1;
    }

    public int parent(int idx) {
        if (this.myParents == null) {
            this.myParents = new IntArray(IntCollections.repeat((int)-1, (int)this.myForest.size()));
        }
        if (this.myForest.getDepth(idx) == 0) {
            return -1;
        }
        int parent = this.myParents.get(idx);
        if (parent < 0) {
            parent = this.calcParent(idx);
        }
        assert (parent >= 0);
        return parent;
    }

    private int calcParent(int idx) {
        if (this.mySiblingBuffers == null) {
            this.mySiblingBuffers = new ArrayList<WritableIntList>(4);
        }
        int i = idx;
        int targetDepth = this.myForest.getDepth(idx);
        int lastRelDepth = -1;
        while (true) {
            int relDepth;
            if ((relDepth = this.myForest.getDepth(i) - targetDepth) < lastRelDepth) {
                assert (relDepth + 1 == lastRelDepth);
                for (IntIterator siblingIdx : this.mySiblingBuffers.get(lastRelDepth)) {
                    this.myParents.set(siblingIdx.value(), i);
                }
            }
            if (relDepth < 0) break;
            for (int j = lastRelDepth + 1; j <= relDepth; ++j) {
                if (j == this.mySiblingBuffers.size()) {
                    this.mySiblingBuffers.add((WritableIntList)new IntArray());
                }
                this.mySiblingBuffers.get(j).clear();
            }
            this.mySiblingBuffers.get(relDepth).add(i);
            lastRelDepth = relDepth;
            int parent = this.myParents.get(i);
            if (parent >= 0) {
                i = parent;
                continue;
            }
            --i;
        }
        return this.myParents.get(idx);
    }

    public int depth(int idx) {
        return this.myForest.getDepth(idx);
    }

    public long row(int idx) {
        return this.myForest.getRow(idx);
    }

    public LongIterator rows(final IntIterator indices) {
        return new LongFindingIterator(){

            protected boolean findNext() {
                if (indices.hasNext()) {
                    this.myNext = IndexedForest.this.myForest.getRow(indices.nextValue());
                    return true;
                }
                return false;
            }
        };
    }

    public int size() {
        return this.myForest.size();
    }

    public Forest getForest() {
        return this.myForest;
    }
}

