/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class JsonMapUtil {
    @Contract(value="_, false, _, _ -> !null")
    public static Map<String, Object> copyParameters(Map<?, ?> parameters, boolean allowNull, boolean makeImmutable, boolean verify) {
        boolean empty;
        boolean bl = empty = parameters == null || parameters.isEmpty();
        if (empty) {
            if (allowNull) {
                return null;
            }
            if (makeImmutable) {
                return Collections.emptyMap();
            }
        }
        return JsonMapUtil.mergeParameters(makeImmutable, verify, parameters);
    }

    @NotNull
    public static Map<String, Object> mergeParameters(boolean makeImmutable, boolean verify, Map<?, ?> ... parameters) {
        LinkedHashMap<String, Object> r = new LinkedHashMap<String, Object>();
        if (parameters != null) {
            for (Map<?, ?> map : parameters) {
                if (map == null) continue;
                for (Map.Entry<?, ?> e : map.entrySet()) {
                    Object key = e.getKey();
                    Object value = e.getValue();
                    if (verify) {
                        if (key == null) {
                            throw new IllegalArgumentException("null key");
                        }
                        if (!(key instanceof String)) {
                            throw new IllegalArgumentException("non-string key: " + key);
                        }
                        JsonMapUtil.checkValidParameter(value);
                    }
                    r.put((String)key, JsonMapUtil.copyParameter(value, makeImmutable));
                }
            }
        }
        return makeImmutable ? Collections.unmodifiableMap(r) : r;
    }

    public static Object copyParameter(Object value, boolean makeImmutable) {
        if (value instanceof List) {
            List list = (List)value;
            ArrayList<Object> r = new ArrayList<Object>(list.size());
            for (Object elem : list) {
                r.add(JsonMapUtil.copyParameter(elem, makeImmutable));
            }
            return makeImmutable ? Collections.unmodifiableList(r) : r;
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            LinkedHashMap<String, Object> r = new LinkedHashMap<String, Object>();
            for (Map.Entry e : map.entrySet()) {
                r.put(String.valueOf(e.getKey()), JsonMapUtil.copyParameter(e.getValue(), makeImmutable));
            }
            return makeImmutable ? Collections.unmodifiableMap(r) : r;
        }
        return value;
    }

    public static void checkValidParameter(Object value) throws IllegalArgumentException {
        try {
            JsonMapUtil.checkValidParameter0(value);
        }
        catch (StackOverflowError e) {
            throw new IllegalArgumentException("stack overflow", e);
        }
    }

    private static void checkValidParameter0(Object value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException("null value");
        }
        if (value instanceof String || value instanceof Integer || value instanceof Long || value instanceof Double || value instanceof Boolean) {
            return;
        }
        if (value instanceof List) {
            List list = (List)value;
            int index = 0;
            for (Object elem : list) {
                try {
                    JsonMapUtil.checkValidParameter0(elem);
                }
                catch (IllegalArgumentException ex) {
                    throw new IllegalArgumentException("invalid list: invalid value at index " + index + ": " + ex.getMessage(), ex);
                }
                ++index;
            }
            return;
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            for (Map.Entry e : map.entrySet()) {
                if (!(e.getKey() instanceof String)) {
                    throw new IllegalArgumentException("invalid map: non-string key " + e.getKey());
                }
                try {
                    JsonMapUtil.checkValidParameter0(e.getValue());
                }
                catch (IllegalArgumentException ex) {
                    throw new IllegalArgumentException("invalid map: invalid value for key " + e.getKey() + ": " + ex.getMessage(), ex);
                }
            }
            return;
        }
        throw new IllegalArgumentException("invalid value type: " + value.getClass().getName());
    }
}

