package com.almworks.jira.structure.api.attribute.loader.basic;

import com.almworks.jira.structure.api.attribute.AttributeSpec;
import com.almworks.jira.structure.api.attribute.loader.ScanningAttributeContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.*;
import java.util.stream.Stream;

public class ScanningLongSumLoader extends AbstractScanningLoader<Long> {
  private final AttributeSpec<Long> myDependency;

  public ScanningLongSumLoader(@NotNull AttributeSpec<Long> spec, AttributeSpec<Long> dependency) {
    super(spec);
    myDependency = dependency;
  }

  @Nullable
  @Override
  public Set<AttributeSpec<?>> getAttributeDependencies() {
    return Collections.singleton(myDependency);
  }

  @Override
  @Nullable
  protected Long loadValueForPassingRow(@Nullable Long precedingValue, ScanningAttributeContext context) {
    return Stream.of(precedingValue, context.getDependencyValue(myDependency))
      .filter(Objects::nonNull)
      .reduce(Long::sum)
      .orElse(null);
  }
}
