package com.almworks.jira.structure.api.generator;

import com.almworks.jira.structure.api.forest.ForestSource;
import com.almworks.jira.structure.api.forest.action.ForestAction;

public class CoreGeneratorParameters {
  /**
   * When true, actions are disabled.
   * Applies to: all generators
   * Type: boolean
   * Default: missing (false)
   *
   * @see ForestSource#apply(ForestAction)
   */
  public static final String DISABLE_ACTIONS = "disableActions";

  /**
   * Parameters to select a range of levels to apply the generator.
   * Applies to: all extenders, all sorters
   * Type: integer
   * Default: missing (all levels)
   */
  public static final String LEVEL_FROM = "from";
  public static final String LEVEL_TO = "to";

  /**
   * Parameter to apply generator on one specific level.
   * Applies to: all filters, all groupers
   * Type: integer
   * Default: filters - missing (all levels); groupers - current level
   */
  public static final String LEVEL = "level";

  /**
   * Filter parameter: if true, an item may be hidden even if it has matching sub-items
   * Applies to: all filters
   * Type: boolean
   * Default: missing (false)
   */
  public static final String FILTER_HARD = "hard";

  /**
   * Filter parameter: if true, all sub-items of matching items also will be shown
   * Applies to: all filters
   * Type: boolean
   * Default: missing (false)
   */
  public static final String FILTER_SHOW_SUBITEMS = "showSubItems";

  /**
   * Parameter to enable including other groups when counting the level.
   * Applies to: all groupers
   * Type: boolean
   * Default: missing (false)
   */
  public static final String GROUPER_LEVEL_INCLUDE_GROUPS = "includeGroups";

  /**
   * Parameter to set sorting direction.
   * Applies to: all sorters
   * Type: boolean
   * Default: false
   */
  public static final String SORT_DESCENDING = "desc";

  /**
   * Parameter to set the maximum number of rows inserted.
   * Applies to: JQL Inserter
   * Type: int
   * Default: 1000
   */
  public static final String INSERTER_LIMIT = "limit";

  /**
   * Defines JQL for the generator.
   * Applies to: JQL Inserter
   * Type: String
   * Default: none (usually, mandatory parameter)
   */
  public static final String JQL = "jql";

  /**
   * Defines JIRA field ID the the generator works on.
   * Applies to: Field Grouper, Agile Rank Sorter
   * Type: String
   * Default: none (usually, mandatory parameter)
   */
  public static final String FIELD_ID = "fieldId";
}
