package com.almworks.jira.structure.api.generator.util;

import com.almworks.jira.structure.api.generator.ItemChangeFilter;
import com.almworks.jira.structure.api.generator.StructureGenerator;
import com.almworks.jira.structure.api.item.ItemIdentity;
import com.almworks.jira.structure.api.row.StructureRow;
import org.jetbrains.annotations.NotNull;

import java.util.Set;

/**
* @author pashky
*/
public interface RecordingItemChangeFilter extends ItemChangeFilter {
  RecordingItemChangeFilter EMPTY_FILTER = new EmptyFilter();

  void recordItem(StructureRow row);

  void recordItem(ItemIdentity itemId);

  class EmptyFilter implements RecordingItemChangeFilter {
    @Override
    public void recordItem(StructureRow row) {}

    @Override
    public void recordItem(ItemIdentity id) {}

    @Override
    public boolean accept(@NotNull Set<ItemIdentity> itemIds, @NotNull StructureGenerator.ItemChangeFilterContext context) {
      return false;
    }
  }
}
