package com.almworks.jira.structure.api.attribute;

import com.almworks.integers.LongSizedIterable;
import com.atlassian.annotations.PublicApi;
import org.jetbrains.annotations.Nullable;

import java.util.function.*;

/**
 * An object that implements {@code RowValues} interface is supplied as a result of attributes calculation by
 * {@link StructureAttributeService}. The interface allows retrieval of values by row ID and attribute specification.
 *
 * @see StructureAttributeService
 * @see AttributeSpec
 */
@PublicApi
public interface RowValues extends LoadedValues<Long> {
  RowValues EMPTY = new RowValues() {
    @Nullable
    @Override
    public <T> LoadedValue<T> getLoadedValue(@Nullable Long key, @Nullable AttributeSpec<T> attribute) {
      return null;
    }

    @Override
    public void consume(Function<AttributeSpec<?>, BiConsumer<LongSizedIterable, LongFunction<LoadedValue<?>>>> consumer) {}
  };

  /**
   * Passes all data to the consumer. Consumer will be called only once for each attribute spec. It can return a null
   * or a biconsumer that will then be fed all row ids that are in use and a function to retrieve a value for each row id.
   *
   * @param consumer
   */
  void consume(Function<AttributeSpec<?>, BiConsumer<LongSizedIterable, LongFunction<LoadedValue<?>>>> consumer);

  default <T> T get(long key, @Nullable AttributeSpec<T> attribute) {
    // this method is needed because otherwise get(1, attribute) will fail - int won't be converted to T=Long because of erasure
    return get((Long)key, attribute);
  }
}
