package com.almworks.jira.structure.api.attribute.loader.basic;

import com.almworks.jira.structure.api.attribute.AttributeSpec;
import com.almworks.jira.structure.api.attribute.loader.AttributeLoader;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractAttributeLoader<A> implements AttributeLoader<A> {
  @NotNull
  protected final AttributeSpec<A> mySpec;

  protected AbstractAttributeLoader(@NotNull AttributeSpec<A> spec) {
    //noinspection ConstantConditions
    if (spec == null) {
      throw new IllegalArgumentException("null spec");
    }
    mySpec = spec;
  }

  @NotNull
  public final AttributeSpec<A> getAttributeSpec() {
    return mySpec;
  }

  @Override
  public String toString() {
    return getClass().getName() + "(" + mySpec + ")";
  }
}
