package com.almworks.jira.structure.api.attribute.loader.reduce;

import com.almworks.jira.structure.api.attribute.AttributeSpec;
import com.almworks.jira.structure.api.attribute.AttributeValue;
import com.almworks.jira.structure.api.attribute.loader.AggregateAttributeContext;
import org.jetbrains.annotations.NotNull;

import java.util.Collections;
import java.util.Set;

public abstract class SingleDependencyReducingAggregateLoader<T> extends ReducingAggregateLoader<T> {
  protected final AttributeSpec<T> myDependency;

  protected SingleDependencyReducingAggregateLoader(AttributeSpec<T> spec, @NotNull AttributeSpec<T> dependency) {
    super(spec);
    myDependency = dependency;
  }

  @NotNull
  @Override
  protected AttributeValue<T> getSelfValue(AggregateAttributeContext context) {
    return context.getDependencyAttributeValue(myDependency);
  }

  @NotNull
  @Override
  public Set<AttributeSpec<?>> getAttributeDependencies() {
    return Collections.singleton(myDependency);
  }
}
