package com.almworks.jira.structure.api.generator;

import org.jetbrains.annotations.Nullable;

import java.util.Map;

public class GeneratorPreset {
  private final String myLabel;
  private final String myDescription;
  private final Map<String, Object> myParameters;

  public GeneratorPreset(String label, Map<String, Object> parameters) {
    this(label, null, parameters);
  }

  public GeneratorPreset(String label, @Nullable String description, Map<String, Object> parameters) {
    myLabel = label;
    myDescription = description;
    myParameters = parameters;
  }

  public String getLabel() {
    return myLabel;
  }

  @Nullable
  public String getDescription() {
    return myDescription;
  }

  public Map<String, Object> getParameters() {
    return myParameters;
  }
}
