package com.almworks.jira.structure.api.process;

import com.almworks.jira.structure.api.util.I18nText;

/**
 * A {@code ProgressGauge} allows you to communicate with a background process.
 */
public interface ProgressGauge {
  /**
   * Returns a short description of the current activity.
   */
  I18nText getActivity();

  /**
   * Returns process completion percentage, 0 to 100, or -1 if progress is unknown/indeterminate.
   */
  int getPercentComplete();

  /**
   * Ask the process to stop. It's up to the process to decide what to do about this request.
   */
  void cancel();
}
