package com.almworks.jira.structure.api.query;

import com.atlassian.annotations.PublicApi;

import static com.almworks.jira.structure.api.query.StructureQueryBuilder.Head;
import static com.almworks.jira.structure.api.query.StructureQueryBuilder.StartStep;

/**
 * Factory for creating new instances of {@link StructureQueryBuilder}.
 * @see StructureQueryBuilder
 * @see StructureQuery
 */
@PublicApi
public interface StructureQueryBuilderFactory {
  /** 
   * Creates a new {@link StructureQueryBuilder}.
   * @return structure query builder
   * */
  StartStep<Head> builder();
}
