package com.almworks.jira.structure.api.template;

import com.almworks.jira.structure.api.structure.Structure;
import org.jetbrains.annotations.NotNull;

import java.util.Map;

/**
 * @author alexeypegov
 */
public interface NewStructureTemplate {

  boolean isEnabled();

  @NotNull
  String getInitialStep();

  @NotNull
  NewStructureTemplateStep createStep(@NotNull String step, @NotNull Map<String, Object> params, NewStructureTemplateContext context) throws StructureTemplateException;

  void configureNewStructure(@NotNull Structure structure, @NotNull Map<String, Object> params) throws StructureTemplateException;

  default String getCreateButtonTextKey() {
    return "s.tpl.btn.finish.name";
  }

  default String prepareNewStructureUrl(Structure structure) {
    return "/secure/StructureBoard.jspa?s=" + structure.getId();
  }

  default boolean shouldRedirectForNewStructure() {
    return false;
  }

  default boolean hasCustomFinalStep() {
    return false;
  }
}
