package com.almworks.jira.structure.api.event;

import com.almworks.integers.LongArray;
import com.almworks.integers.LongList;
import org.jetbrains.annotations.NotNull;

/**
 * This event is dispatched when an operation on links is detected - creation of a new link, or removal of existing
 * link.
 */
public class LinkChangeEvent extends JiraChangeEvent {
  private final long myLinkTypeId;
  private final long mySourceId;
  private final long myDestinationId;

  public LinkChangeEvent(@NotNull JiraChangeType changeType, long linkTypeId, long sourceId, long destinationId) {
    super(changeType);
    myLinkTypeId = linkTypeId;
    mySourceId = sourceId;
    myDestinationId = destinationId;
  }

  public long getLinkTypeId() {
    return myLinkTypeId;
  }

  public long getSourceId() {
    return mySourceId;
  }

  public long getDestinationId() {
    return myDestinationId;
  }

  public LongList getAffectedIssuesSorted() {
    return mySourceId < myDestinationId ? LongArray.create(mySourceId, myDestinationId) : LongArray.create(myDestinationId, mySourceId);
  }

  public String toString() {
    return getChangeType() + "(" + myLinkTypeId + ':' + mySourceId + "=>" + myDestinationId + ')';
  }

  public static long getSourceId(JiraChangeEvent event) {
    if (event instanceof LinkChangeEvent) {
      return ((LinkChangeEvent) event).getSourceId();
    }
    return 0;
  }

  public static long getDestinationId(JiraChangeEvent event) {
    if (event instanceof LinkChangeEvent) {
      return ((LinkChangeEvent) event).getDestinationId();
    }
    return 0;
  }

  public static long getLinkTypeId(JiraChangeEvent event) {
    if (event instanceof LinkChangeEvent) {
      return ((LinkChangeEvent) event).getLinkTypeId();
    }
    return 0;
  }
}
