package com.almworks.jira.structure.api.extension.license;

import org.jetbrains.annotations.NotNull;

public class LicenseException extends Exception {
  @NotNull
  private final StructureLicenseError myError;

  public LicenseException(@NotNull StructureLicenseError error) {
    myError = error;
  }

  public LicenseException(@NotNull StructureLicenseError error, Throwable cause) {
    super(cause);
    myError = error;
  }

  @NotNull
  public StructureLicenseError getError() {
    return myError;
  }

  public String toString() {
    return "license error " + myError.getCode();
  }
}
