package com.almworks.jira.structure.api.forest.action;

import java.util.List;

/**
* @author pashky
*/
public class InteractionParameter {
  private final long myRowId;
  private final String myParameterId;
  private final String myMessage;
  private final List<InteractionParameterValue> myValues;

  public InteractionParameter(long rowId, String parameterId, String message, List<InteractionParameterValue> values) {
    myRowId = rowId;
    myParameterId = parameterId;
    myMessage = message;
    myValues = values;
  }

  public long getRowId() {
    return myRowId;
  }

  public String getParameterId() {
    return myParameterId;
  }

  public String getMessage() {
    return myMessage;
  }

  public List<InteractionParameterValue> getValues() {
    return myValues;
  }

  @Override
  public String toString() {
    return myRowId + ":" + myParameterId + "?" + (myValues.isEmpty() ? "" : myValues);
  }
}
