package com.almworks.jira.structure.api.forest.raw;

import com.almworks.jira.structure.api.error.StructureErrors;
import com.almworks.jira.structure.api.error.StructureException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForestMergeStructureException extends StructureException {
  private static final Logger logger = LoggerFactory.getLogger(ForestMergeStructureException.class);
  private final long myMergePoint;
  private final long myMergePointFatherFromForest;
  private final long myMergePointFatherRoot;
  private final String mySourceForestString;
  private final String myTargetForestString;
  private static final String FULL_FOREST_PLACEHOLDER = "(n/a)";

  public ForestMergeStructureException(long mergePoint, long mergePointFatherFromSourceForest,
    @NotNull Forest sourceForest, @NotNull Forest targetForest)
  {
    super(StructureErrors.INVALID_FOREST_OPERATION, null, mergePoint,
      "cannot merge " + sourceForest + " in " + targetForest + " under " + mergePoint + ": issue " + mergePointFatherFromSourceForest + " on parent path is in the merged forest");
    myMergePoint = mergePoint;
    myMergePointFatherFromForest = mergePointFatherFromSourceForest;
    myMergePointFatherRoot = sourceForest.getRow(sourceForest.getPathIndexAtDepth(sourceForest.indexOf(mergePointFatherFromSourceForest), 0));
    mySourceForestString = logger.isTraceEnabled() ? sourceForest.toFullString() : FULL_FOREST_PLACEHOLDER;
    myTargetForestString = logger.isTraceEnabled() ? targetForest.toFullString() : FULL_FOREST_PLACEHOLDER;
  }

  public long getMergePoint() {
    return myMergePoint;
  }

  public long getMergePointFatherFromForest() {
    return myMergePointFatherFromForest;
  }

  public long getMergePointFatherRoot() {
    return myMergePointFatherRoot;
  }

  public String getSourceForestString() {
    return mySourceForestString;
  }

  public String getTargetForestString() {
    return myTargetForestString;
  }
}
