package com.almworks.jira.structure.api.generator;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Map;

public interface ActionHandlingGenerator<T extends ActionHandler> extends StructureGenerator {
  @Nullable
  T createActionHandler(@NotNull Map<String, Object> parameters);

  interface Inserter extends ActionHandlingGenerator<ActionHandler.InserterActionHandler>, StructureGenerator.Inserter {}
  interface Extender extends ActionHandlingGenerator<ActionHandler.ExtenderActionHandler>, StructureGenerator.Extender {}
  interface Grouper extends ActionHandlingGenerator<ActionHandler.GrouperActionHandler>, StructureGenerator.Grouper {}
  interface Sorter extends ActionHandlingGenerator<ActionHandler.SorterActionHandler>, StructureGenerator.Sorter {}
}
