package com.almworks.jira.structure.api.attribute.loader.basic;

import com.almworks.jira.structure.api.attribute.AttributeSpec;
import com.almworks.jira.structure.api.attribute.loader.reduce.SingleDependencyReducingAggregateLoader;
import org.jetbrains.annotations.NotNull;

import java.util.List;

public class LongSumLoader extends SingleDependencyReducingAggregateLoader<Long> {
  public LongSumLoader(AttributeSpec<Long> spec, AttributeSpec<Long> dependency) {
    super(spec, dependency);
  }

  @Override
  public Long reduce(@NotNull List<Long> list) {
    long value = 0;
    boolean defined = false;
    for (Long item : list) {
      if (item != null) {
        defined = true;
        value += item;
      }
    }
    return defined ? value : null;
  }
}
