package com.almworks.jira.structure.api.util;

import com.almworks.integers.IntIterators;
import com.almworks.integers.LongList;
import com.almworks.integers.wrappers.LongIntHppcOpenHashMap;

import java.util.Map;

/**
 * todo why don't we add this to ArrayForest? We could have a method indexOfCached() which would consult the cache;
 * todo | the cache would be invalidated on any forest update; also could be "smart" (invalidate only indices after the point of change)
 * todo Or: merge with IndexedForest
 * @author Igor Sereda
 */
public class LongListHashIndex {
  private final LongIntHppcOpenHashMap myMap;

  public LongListHashIndex(LongList list) {
    myMap = new LongIntHppcOpenHashMap(list.size());
    myMap.putAllKeys(list, IntIterators.range(list.size()));
  }

  public LongListHashIndex(Map<Long, Integer> map) {
    myMap = new LongIntHppcOpenHashMap(map.size());
    for (Map.Entry<Long, Integer> e : map.entrySet()) {
      Long key = e.getKey();
      Integer value = e.getValue();
      if (key != null && value != null && value >= 0) {
        myMap.put(key, value);
      }
    }
  }

  public int indexOf(long value) {
    if (myMap.containsKey(value)) {
      return myMap.lget();
    } else {
      return -1;
    }
  }

  public int size() {
    return myMap.size();
  }
}
