package com.almworks.jira.structure.api.attribute;

import com.almworks.integers.*;
import com.almworks.jira.structure.api.attribute.loader.AttributeContext;
import com.almworks.jira.structure.api.attribute.loader.AttributeLoader;
import com.almworks.jira.structure.api.cache.access.ForestAccessCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.function.Predicate;

public class AttributeLoaderSecurity {
  private static final String INVISIBLE_ROW_IDS = "AttributeLoaderSecurity.INVISIBLE_ROW_IDS";

  public static void collectInvisibleRows(@NotNull LongSet rowIds, @NotNull AttributeContext context,
    ForestAccessCache forestAccessCache)
  {
    if (rowIds.isEmpty()) return;
    RowCheckingData data = context.getObject(INVISIBLE_ROW_IDS);
    if (data == null) {
      data = new RowCheckingData(new LongOpenHashSet(rowIds.size()), new LongOpenHashSet());
      context.putObject(INVISIBLE_ROW_IDS, data);
    }
    LongArray checkArray = new LongArray(rowIds.size());
    for (LongIterator ri : rowIds) if (data.checkedRows.include(ri.value())) checkArray.add(ri.value());
    data.invisibleRows.addAll(forestAccessCache.getInvisibleRows(checkArray, context.getUser()));
  }

  public static boolean isRowInvisible(AttributeLoader.Context context) {
    RowCheckingData data = get(context);
    if (data == null) {
      // weird
      return true;
    }
    assert data.checkedRows.contains(context.getRow().getRowId()) : context.getRow().getRowId() + " " + data.checkedRows + " " + data.invisibleRows;
    return data.invisibleRows.contains(context.getRow().getRowId());
  }

  public static Predicate<Long> getRowInvisiblePredicate(AttributeContext context) {
    RowCheckingData data = get(context);
    if (data == null) {
      // weird
      return v -> true;
    }
    return row -> {
      assert data.checkedRows.contains(row) : row + " " + data.checkedRows + " " + data.invisibleRows;
      return data.invisibleRows.contains(row);
    };
  }

  @Nullable
  private static RowCheckingData get(AttributeContext context) {
    try {
      return context.getObject(INVISIBLE_ROW_IDS);
    } catch (ClassCastException e) {
      return null;
    }
  }


  private static class RowCheckingData {
    @NotNull
    private final LongOpenHashSet checkedRows;
    @NotNull
    private final LongOpenHashSet invisibleRows;

    private RowCheckingData(@NotNull LongOpenHashSet checkedRows, @NotNull LongOpenHashSet invisibleRows) {
      this.checkedRows = checkedRows;
      this.invisibleRows = invisibleRows;
    }
  }
}
