package com.almworks.jira.structure.api.attribute.loader;

import com.almworks.jira.structure.api.attribute.AttributeSpec;
import org.jetbrains.annotations.NotNull;

import java.util.List;

public abstract class AbstractAggregateLoader<T> extends AbstractAttributeLoader<T> implements AttributeLoader.Aggregate<T> {
  protected AbstractAggregateLoader(AttributeSpec<T> spec) {
    super(spec);
  }

  public final boolean isEveryItemTypeSupported() {
    return true;
  }

  public final boolean isItemTypeSupported(String itemType) {
    return true;
  }

  public AttributeCachingStrategy getCachingStrategy() {
    return AttributeCachingStrategy.SHOULD;
  }

  /**
   * Returns the first error {@link AttributeValue} from list of children values.
   *
   * @param children list of children values
   * @param <T> {@link AttributeValue} generic type
   * @return the first child error or {@code null} if none.
   */
  public static <T> AttributeValue<T> firstChildError(@NotNull List<AttributeValue<T>> children) {
    return children
      .stream()
      .filter(v -> v != null && v.isError())
      .findFirst()
      .orElse(null);
  }
}
