package com.almworks.jira.structure.api.attribute.loader;

import com.almworks.jira.structure.api.attribute.AttributeSpec;
import com.almworks.jira.structure.api.item.ItemIdentity;

import java.util.*;

// naive implementation - needs optimization
// non-naive implementation will require support from the system
public abstract class AbstractDistinctAggregateLoader<T> extends AbstractAggregateLoader<T> {
  public AbstractDistinctAggregateLoader(AttributeSpec<T> spec) {
    super(spec);
  }

  @Override
  public AttributeValue<T> loadValue(List<AttributeValue<T>> childrenValues, AggregateContext<T> context) {
    Map<ItemIdentity, T> values = new HashMap<>();
    for (AttributeValue<T> childValue : childrenValues) {
      if (childValue != null && childValue.isDefined()) {
        //noinspection unchecked
        Map<ItemIdentity, T> childData = childValue.getLoaderData(Map.class);
        if (childData != null) {
          values.putAll(childData);
        }
      }
    }
    ItemIdentity itemId = context.getRow().getItemId();
    if (!values.containsKey(itemId)) {
      T value = getRowValue(context);
      if (value != null) {
        values.put(itemId, value);
      }
    }
    T total = combine(values.values(), context);
    return AttributeValue.of(total).withData(Collections.unmodifiableMap(values));
  }

  protected abstract T getRowValue(AggregateContext<T> context);

  protected abstract T combine(Collection<T> values, AggregateContext<T> context);
}
