package com.almworks.jira.structure.api.attribute.loader;

import com.almworks.jira.structure.api.attribute.AttributeSpec;
import org.jetbrains.annotations.NotNull;

import java.util.Collections;
import java.util.Set;

public abstract class AbstractForestIndependentAttributeLoader<T> extends AbstractAttributeLoader<T> 
  implements AttributeLoader.ForestIndependent<T> 
{
  public AbstractForestIndependentAttributeLoader(AttributeSpec<T> spec) {
    super(spec);
  }

  @Override
  public boolean isEveryItemTypeSupported() {
    return true;
  }

  @Override
  public boolean isItemTypeSupported(String itemType) {
    return true;
  }

  @NotNull
  @Override
  public Set<? extends AttributeSpec<?>> getAttributeDependencies() {
    return Collections.emptySet();
  }

  @Override
  public AttributeCachingStrategy getCachingStrategy() {
    return AttributeCachingStrategy.guessCachingStrategy(getAttributeSpec());
  }
}
