package com.almworks.jira.structure.api.attribute.loader;

import com.almworks.jira.structure.api.attribute.AttributeSpec;

public abstract class AbstractPropagateLoader<T> extends AbstractAttributeLoader<T> implements AttributeLoader.Propagate<T> {
  public AbstractPropagateLoader(AttributeSpec<T> spec) {
    super(spec);
  }

  public boolean isEveryItemTypeSupported() {
    return true;
  }

  public boolean isItemTypeSupported(String itemType) {
    return true;
  }

  public AttributeCachingStrategy getCachingStrategy() {
    return AttributeCachingStrategy.SHOULD;
  }
}
