package com.almworks.jira.structure.api.attribute.loader;

import com.almworks.jira.structure.api.attribute.AttributeSpec;
import com.almworks.jira.structure.api.attribute.ValueFormat;

public enum AttributeCachingStrategy {
  // the value should be cached to avoid excessive recalculation
  SHOULD,

  // the value could be cached, but it would likely be a waste of space, because it is relatively easy to calculate
  MAY,

  // the value is based on some non-trackable data (external database value, time-based value)
  MUST_NOT,
  ;

  /**
   * Guessing if the value is cacheable based on the value format. A non-standard format will likely be an object
   * like Project, which shouldn't be cacheable.
   */
  public static AttributeCachingStrategy guessCachingStrategy(AttributeSpec<?> spec) {
    ValueFormat<?> format = spec.getFormat();
    if (ValueFormat.HTML.equals(format)) return MUST_NOT;
    return ValueFormat.getStandardFormat(format.getFormatId()) != null ? MAY : MUST_NOT;
  }
}
