package com.almworks.jira.structure.api.attribute.loader;

import org.jetbrains.annotations.NotNull;

// defines how attribute for a row depends on the values of the same attribute for other rows in the forest
// not the same as invalidation data / attribute trail - which is closure of the forest dependency todo what?
public enum ForestDependencyType {
  // uses only a single row's data to calculate the result (and, possibly, dependencies for the same row)
  INDEPENDENT(AttributeLoader.ForestIndependent.class),

  // row and children (aggregate)
  AGGREGATE(AttributeLoader.Aggregate.class),

  // parent calculates value for all its children at once
  PROPAGATE(AttributeLoader.Propagate.class)
  ;
  
  private final Class<? extends AttributeLoader> myLoaderClass;

  ForestDependencyType(Class<? extends AttributeLoader> loaderClass) {
    myLoaderClass = loaderClass;
  }
  
  public boolean is(AttributeLoader<?> loader) {
    return loader != null && myLoaderClass.isAssignableFrom(loader.getClass());
  }

  @NotNull
  public static ForestDependencyType getType(AttributeLoader<?> loader) {
    for (ForestDependencyType type : values()) {
      if (type.is(loader)) {
        return type;
      }
    }
    assert false : loader != null ? loader.getClass() : "null";
    if (loader == null) throw new NullPointerException();
    throw new IllegalArgumentException(loader.getClass().getName());
  }
}
